/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
#include "derivative.h"
#include "flash_operation_api.h"

char Src_Data[32]@0x18C0;               //the data buffer save the data will be programmed to flash, Mzximum size is 32
char Data_Len @0x8C;                    //the valid data length in data buffer
unsigned int Obj_Start_Addr@0x0088;     //0x88,89  keep start address where the data in buffer will be programmed
char Stat@0x87;                         //0x87 the return value of flash erase and program; 0x01: success, other value: failed
char Index@0x86;                        //this byte is occupied by Program routine

char Flash_Erase(unsigned char* Addr); //flash erase routine
char Flash_Program(void);              //flash program routine

char Flash_Erase(unsigned char* Addr)
{
  Obj_Start_Addr =  (unsigned int)Addr;     //0x88 keep the start address for erasing or programming
  asm  
  {
    LDHX 0x0088                             //write the start address to HX register
    
    JSR  PAGE_ERASE_ROUTINE_ADDR            //Call the erasing routine in boot ROM
    
    STA  Stat                               //save the erasing result 00:succ, other value: fail
  } 
  return Stat;
}


char Flash_Program(void)
{
  asm
  {
      JSR PROGRAM_ROUTINE_ADDR             //call the programming routine in boot ROM
  }
  return Stat;                             //return the programming result 0x01: successful, other values: fail
}

